//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Rescaling Weights
// Objective: 	Rescaling all weights to include nursing home residents in the
//				sample and reference population. Creating new weights that match
//				nursing home residents to administrative benchmarks.
//
// Created: 	09/04/2021
// Modified: 	16/11/2021
//==============================================================================

**************************
*** Importing the Data ***
**************************

clear

cd "XXXX"	// set the content directory here

use HILDA_restricted_combined.dta // importing the original data

*************************************************************
*** Merging the Data with Calculated Nursing Home Weights ***
*************************************************************

merge 1:1 xwaveid wave using HILDA_restricted_combined_nonprivate_weights, nogen	// merging in the weights for nursing home residents

******************************************************************
*** Benchmarking Population Weights for Nursing Home Residents ***
******************************************************************

merge m:1 wave using "Adjusted_Ref_Pop.dta", nogen	// merging in data containing benchmarks for the Australian nursing home population (from Adjusted Reference Population spreadsheet)

egen sum_nh_wte = sum(new_hhwte) if dodtyp == 1, by(wave)	// creating a variable that equals the sum of the population level enumerated person weights for nursing home residents

gen benchmark_ratio = australianresidentialagedcare / sum_nh_wte	// generating a ratio that reflects the extent of under representation of nursing home residents in the HILDA sample - it is equal to the Australian residential aged care population divided by the sum of enumerated person population weights of nursing home residents

local pop_wt new_hhwth new_hhwte new_hhwtrp	// generating a local macro that includes the new population weights

foreach w in `pop_wt' {
    gen benchmarked_`w' = benchmark_ratio * `w' if dodtyp == 1 & `w' >= 0
	replace benchmarked_`w' = `w' if dodtyp != 1
}	// rescaling the population weights for aged care residents so that they are accurately represented

egen sum_benchmarked_hhwte = sum(benchmarked_new_hhwte), by(wave)	// generating a variable equal to the sum of the newly rescaled enumerated person population weights for nursing home residents

sort xwaveid wave	// sorting the data by xwaveid and wave

drop new_hhwt*	// dropping new population weights that have not been scaled to match the benchmark population

save HILDA_restricted_combined_rescaled, replace	// saving the combined and rescaled dataset